local ps = gPlayerSyncTable
local np = gNetworkPlayers

DIALOG_STATE_OPENING = 0
DIALOG_STATE_OPENED = 1
DIALOG_STATE_SCROLLING = 2
DIALOG_STATE_CLOSING = 3

DIALOG_STYLE_VANILLA = 0
DIALOG_STYLE_PROGRESSIVE = 1

style = DIALOG_STYLE_VANILLA

DIALOG_DURATION = 15
TEXT_SCALE = 1.5

LINE_SPACING = 10

dialogPosX = 80
dialogPosY = 60
dialogWidth = 120
dialogHeight = 50

linesPerPage = math.floor(dialogHeight / LINE_SPACING)

SCROLL_STEP = 10

scrollLength = (linesPerPage * 2) * (5 / SCROLL_STEP)

local DIALOG_ROTATION_SPEED = -65535 / DIALOG_DURATION

local boxColor = {r=0,g=0,b=0,a=150}

dialogTimer = 0
currentPage = 1
totalPages = 1
scrollTimer = 0
scrollOffset = 0

ps[0].isReading = false
boxState = DIALOG_STATE_OPENING
currDialog = nil
showArrow = false

--* these dialogs were made by biobak

DIALOG_ID_0 = 0
DIALOG_ID_1 = 1
DIALOG_ID_2 = 2
DIALOG_ID_3 = 3
DIALOG_ID_4 = 4
DIALOG_ID_5 = 5
DIALOG_ID_6 = 6
DIALOG_ID_7 = 7
DIALOG_ID_8 = 8
DIALOG_ID_9 = 9
DIALOG_ID_10 = 10
DIALOG_ID_11 = 11
DIALOG_ID_12 = 12
DIALOG_ID_13 = 13
DIALOG_ID_14 = 14
DIALOG_ID_15 = 15
DIALOG_ID_16 = 16
DIALOG_ID_17 = 17
DIALOG_ID_18 = 18
DIALOG_ID_19 = 19
DIALOG_ID_20 = 20
DIALOG_ID_21 = 21
DIALOG_ID_22 = 22
DIALOG_ID_23 = 23
DIALOG_ID_24 = 24
DIALOG_ID_25 = 25
DIALOG_ID_26 = 26
DIALOG_ID_27 = 27
DIALOG_ID_28 = 28
DIALOG_ID_29 = 29
DIALOG_ID_30 = 30
DIALOG_ID_31 = 31
DIALOG_ID_32 = 32
DIALOG_ID_33 = 33
DIALOG_ID_34 = 34
DIALOG_ID_35 = 35
DIALOG_ID_36 = 36
DIALOG_ID_37 = 37
DIALOG_ID_38 = 38
DIALOG_ID_39 = 39
DIALOG_ID_40 = 40
DIALOG_ID_41 = 41

DIALOG_0 = (
    "I'm hiding over here because\n"
    .."I'm scared of the dog.\n"
)

DIALOG_1 = (
    "This tunnel is a direct access\n"
    .."to the fortress up top.\n"
    .."Please leave this area clean!\n"
)

DIALOG_2 = (
    "If you activate a Blue\n"
    .."Switch with a ground pound,\n"
    .."blue coins will appear.\n"
    .."Grab them quick, because\n"
    .."they won't stay for long."
)

DIALOG_3 = (
    "The goomba is a wild\n"
    .."species native to the\n"
    .."mushroom kingdom.\n"
    .."They might appear dangerous,\n"
    .."but their bite is nearly\n"
    .."harmless.\n"
    .."Jump on their heads if\n"
    .."they're pestering you!"
)

DIALOG_4 = (
    "Be careful of the Bob-Ombs!\n"
    .."If one of them sees you,\n"
    .."you better make a run for it\n"
    .."or you'll be blown to pieces!\n"
    .."You can also sneak behind\n"
    .."them and grab them if you\n"
    .."want to make one of them\n"
    .."your weapon."
)

DIALOG_5 = (
    "Hey, if you've read that sign \n"
    .."over there, just know I'm one\n"
    .."of the good ones.\n"
    .."I'd never blow up a fly."
)

DIALOG_6 = (
    "This yellow cube is a box!\n"
    .."You can jump to break boxes.\n"
    .."Boxes have things inside.\n"
    .."I hope you're taking notes.\n"
)

DIALOG_7 = (
    "To reach things that are\n"
    .."high up, you can press the\n"
    .."jump button to perform the\n"
    .."\"Jump\" move.\n"
    .."It will allow you to move\n"
    .."vertically.\n"
)

DIALOG_8 = (
    "WARNING!\n"
    .."This room is heavily guarded.\n"
    .."Enter at your own risk."
)

DIALOG_9 = (
    "Don't be intimidated by his\n"
    .."large metal body and sharp\n"
    .."teeth, this lovely dog wants\n"
    .."nothing but pets and cuddles.\n"
    .."He will not eat you whole.\n"
    .."Go ahead and try.\n"
    .." \n"
    .."You can trust me."
)

DIALOG_10 = (
      "Please be kind and leave\n"
    .."the mess in this room\n"
    .."exactly as you found it."
)

DIALOG_29 = (
    "I AM GUARDING THIS ENTRANCE!\n"
    .."DO NOT COME THROUGH!\n"
)

DIALOG_35 = (
    "Hey there!\n"
    .."Lovely day, isn't it?\n"
    .."...Why are you examining me\n"
    .."like that? What'd I do?\n"
)

DIALOG_36 = (
    "What a lovely corner.\n"
    .."The detail on this wall\n"
    .."is absolutely immaculate!"
)

-- MECHANICAL MAZE --

DIALOG_11 = (
    "Both ways fraught with danger!\n"
    .."Watch your feet! Those who\n"
    .."can't swim, tsk, tsk.\n"
    .."Make your way to the left.\n"
    .."RIGHT: Submarine\n"
    .."LEFT: Storage Area\n"
    .."AHEAD: Moist Maze\n"
)

DIALOG_12 = (
    "This way:\n"
    .."STORAGE AREA\n"
)

DIALOG_13 = (
    "Trying not to look down.\n"
    .."I'm afraid of heights.\n"
    .."Bowser put me up here\n"
    .."as punishment."
)

DIALOG_14 = (
    "This alcove is where we\n"
    .."store the one red coin.\n"
    .."Make sure NOTHING\n"
    .."happens to it.\n"
    .."-Bowser"
)

DIALOG_15 = (
    "Collect the caps!\n"
    .."The one in the green block,\n"
    .."the Metal Cap, makes you\n"
    .."invincible and lets you\n"
    .."walk under water.\n"
    .."The blue box gives you a\n"
    .."Vanish Cap, which lets you\n"
    .."go straight through walls.\n"
    .."Combine them, and you'll be\n"
    .."able to do both at once!"
)

DIALOG_16 = (
    "Rule Number 1:\n"
    .."There are exactly 17 boxes\n"
    .."in this alcove.\n"
    .."If this number were to\n"
    .."change, you should make sure\n"
    .."nothing strange is going on."
)

DIALOG_17 = (
    "Rule Number 2:\n"
    .."There should be ONLY\n"
    .."boxes in this alcove.\n"
    .."If there were to be anything\n"
    .."else in there, it should be\n"
    .."disposed of immediately."
)

DIALOG_18 = (
    "Rule number 3:\n"
    .."This should be one of\n"
    .."three explanatory signs.\n"
    .." \n"
    .."If the number of signs were\n"
    .."to be different, the priority\n"
    .."should be to investigate and\n"
    .."rectify the issue."
)

DIALOG_19 = (
    "I'm Bob, and this is my friend Bob.\n"
)

DIALOG_20 = (
    "This is the entrance to the maze.\n"
    .."Keep in mind that the way to\n"
    .."the other exit is left, right,\n"
    .."left, left... right... uh... left?\n"
    .."Sorry, I forgot."
)

DIALOG_21 = (
    "Who put all these boxes\n"
    .."on the submarine?\n"
    .."We can't dive like that.\n"
    .."I want them all gone by\n"
    .."TOMORROW. Got it? \n"
    .."-Bowser"
)

DIALOG_22 = (
    "Welcome to the end of the metal bridge.\n"
    .."We hope you appreciated this journey!\n"
)

DIALOG_23 = (
      "If you look at it from another\n"
    .."perspective, this is the start\n"
    .."of the metal bridge.\n"
    .."Think of the journey ahead!"
)

DIALOG_37 = (
      "...Been locked in here for\n"
    .."years... No way to escape..."
)

DIALOG_38 = (
      "This door must remain CLOSED\n"
    .."at ALL TIMES! The morons from\n"
    .."the construction company should\n"
    .."have put a WALL there but they\n"
    .."are complete INCOMPETENTS!\n"
    .."-Bowser"
)

DIALOG_39 = (
      "This way:\n"
    .."MECHANICAL MAZE\n"
)

DIALOG_40 = (
      "Warning! Maze ahead!\n"
    .."If you are unsure of the path\n"
    .."to take through the maze,\n"
    .."ask the bob-omb patrolling\n"
    .."near another entrance for\n"
    .."clarifications."
)

-- BLIZZ BLAZE BAY

DIALOG_24 = (
    "Hot hot hot! That red stuff\n"
    .."down there is lava.\n"
    .."It comes from a volcano.\n"
    .."Basically, that means don't\n"
    .."even think about touching it."
)

DIALOG_25 = (
    "Right behind this sign is the\n"
    .."domain of the bullies.\n"
    .."You better stand your ground,\n"
    .."cause they'll send you flying!"
)

DIALOG_26 = (
    "Get yourself a Shell!\n"
    .."Shells are a great way to move\n"
    .."around in burning environments.\n"
    .."Just hop on one and surf\n"
    .."right on the lava!"
)

DIALOG_27 = (
    "This right there is a game\n"
    .."of Red Coin Rush!\n"
    .." \n"
    .."Can you press the switch and\n"
    .."get all four coins before\n"
    .."time runs out?"
)

DIALOG_28 = (
    "Don't scrape the walls,\n"
    .."it makes me itchy.\n"
    .."-The snowman\n"
)

DIALOG_30 = (
    "This is a cute little village.\n"
)

DIALOG_31 = (
    "Warning, shaky bridge!\n"
    .."Don't let the chilly bullies\n"
    .."push you off."
)

DIALOG_32 = (
    "Bridge temporarily out of order.\n"
    .."Don't risk it, the extra life\n"
    .."isn't worth your current life."
)

DIALOG_33 = (
    "MISSING: Door handle.\n"
    .."If you find it, please return it.\n"
    .."I think I left the oven on inside."
)

DIALOG_34 = (
    "Santa Claus isn't the only one\n"
    .."who can go down a chimney!\n"
    .."Come on in!\n"
    .."--Cabin Proprietor"
)

DIALOG_41 = (
    "Cabin closed due to cold weather"
)

local sDialogHandler = {
    [DIALOG_ID_0] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 20},
        text = DIALOG_0,
        style = DIALOG_STYLE_VANILLA
    },
    
    [DIALOG_ID_1] = {
        pos = {x = 60, y = 60},
        scale = {width = 130, height = 30},
        text = DIALOG_1,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_2] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 30},
        text = DIALOG_2,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_3] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 30},
        text = DIALOG_3,
        style = DIALOG_STYLE_VANILLA
    },

    
    [DIALOG_ID_4] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 40},
        text = DIALOG_4,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_5] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 30},
        text = DIALOG_5,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_6] = {
        pos = {x = 60, y = 60},
        scale = {width = 130, height = 10},
        text = DIALOG_6,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_7] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 60},
        text = DIALOG_7,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_8] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 20},
        text = DIALOG_8,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_9] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 40},
        text = DIALOG_9,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_10] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 30},
        text = DIALOG_10,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_11] = {
        pos = {x = 60, y = 60},
        scale = {width = 140, height = 40},
        text = DIALOG_11,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_12] = {
        pos = {x = 60, y = 60},
        scale = {width = 70, height = 20},
        text = DIALOG_12,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_13] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 20},
        text = DIALOG_13,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_14] = {
        pos = {x = 60, y = 60},
        scale = {width = 100, height = 20},
        text = DIALOG_14,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_15] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 50},
        text = DIALOG_15,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_16] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 30},
        text = DIALOG_16,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_17] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 30},
        text = DIALOG_17,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_18] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 40},
        text = DIALOG_18,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_19] = {
        pos = {x = 60, y = 60},
        scale = {width = 150, height = 10},
        text = DIALOG_19,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_20] = {
        pos = {x = 60, y = 60},
        scale = {width = 140, height = 50},
        text = DIALOG_20,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_21] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 30},
        text = DIALOG_21,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_22] = {
        pos = {x = 60, y = 60},
        scale = {width = 160, height = 20},
        text = DIALOG_22,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_23] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 30},
        text = DIALOG_23,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_24] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 30},
        text = DIALOG_24,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_25] = {
        pos = {x = 60, y = 60},
        scale = {width = 125, height = 20},
        text = DIALOG_25,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_26] = {
        pos = {x = 60, y = 60},
        scale = {width = 130, height = 30},
        text = DIALOG_26,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_27] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 30},
        text = DIALOG_27,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_28] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 20},
        text = DIALOG_28,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_29] = {
        pos = {x = 60, y = 60},
        scale = {width = 140, height = 20},
        text = DIALOG_29,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_30] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 10},
        text = DIALOG_30,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_31] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 30},
        text = DIALOG_31,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_32] = {
        pos = {x = 60, y = 60},
        scale = {width = 130, height = 30},
        text = DIALOG_32,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_33] = {
        pos = {x = 60, y = 60},
        scale = {width = 140, height = 20},
        text = DIALOG_33,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_34] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 40},
        text = DIALOG_34,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_35] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 20},
        text = DIALOG_35,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_36] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 30},
        text = DIALOG_36,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_37] = {
        pos = {x = 60, y = 60},
        scale = {width = 120, height = 20},
        text = DIALOG_37,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_38] = {
        pos = {x = 60, y = 60},
        scale = {width = 130, height = 60},
        text = DIALOG_38,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_39] = {
        pos = {x = 60, y = 60},
        scale = {width = 100, height = 20},
        text = DIALOG_39,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_40] = {
        pos = {x = 60, y = 60},
        scale = {width = 130, height = 60},
        text = DIALOG_40,
        style = DIALOG_STYLE_VANILLA
    },

    [DIALOG_ID_41] = {
        pos = {x = 60, y = 60},
        scale = {width = 130, height = 10},
        text = DIALOG_41,
        style = DIALOG_STYLE_VANILLA
    },

}

local selectedOption = 1
local totalOptions = 2
local confirmedOption = 0

function paginate_text(text, linesPerPage)
    local lines = {}
    for line in text:gmatch("[^\n]+") do
        table.insert(lines, line)
    end

    local pages = {}
    for i = 1, #lines, linesPerPage do
        local page = {}
        for j = i, math.min(i + linesPerPage - 1, #lines) do
            table.insert(page, lines[j])
        end
        table.insert(pages, page)
    end

    return pages
end

local function handle_menu_navigation()

    local pages = paginate_text(sDialogHandler[currDialog].text, linesPerPage)
    local pageContainsOptions = false
    for _, line in ipairs(pages[currentPage]) do
        if line:match(":OPTION") then
            pageContainsOptions = true
            break
        end
    end

    if not pageContainsOptions then return end

    local m = gMarioStates[0]
    if m.controller.buttonPressed & U_JPAD ~= 0 then
        selectedOption = math.max(selectedOption - 1, 1)
        play_sound(SOUND_MENU_CHANGE_SELECT, gGlobalSoundSource)
    elseif m.controller.buttonPressed & D_JPAD ~= 0 then
        selectedOption = math.min(selectedOption + 1, totalOptions)
        play_sound(SOUND_MENU_CHANGE_SELECT, gGlobalSoundSource)
    end

    if m.controller.buttonPressed & A_BUTTON ~= 0 then
        confirmedOption = selectedOption
        if sDialogHandler[currDialog].choiceFunc and currDialog then
            sDialogHandler[currDialog].choiceFunc(selectedOption)
        end
    end
end

local function hex_to_rgb(hex)
    local r = tonumber(hex:sub(2, 3), 16)
    local g = tonumber(hex:sub(4, 5), 16)
    local b = tonumber(hex:sub(6, 7), 16)
    return r, g, b, 255
end


local function handle_text_effect(text, x, y, scale, waveIntensity, waveSpeed)
    local waveText = {}
    local currentColor = {255, 255, 255, 255}

    local globalTimer = get_global_timer()

    local segments = {}
    local currentSegment = { text = "", isWave = false, waveIntensity = 0, shakeIntensity = 0, color = currentColor }

    for part in text:gmatch("[^__]+") do
        if part:match("^OPTION%s%d+$") then
            local optionIndex = tonumber(part:match("%d+"))
            local optionText = selectedOption == optionIndex and ">" .. part:sub(9) or part:sub(9)

            if selectedOption == optionIndex then
                table.insert(segments, {
                    text = optionText,
                    isWave = false,
                    waveIntensity = 0,
                    shakeIntensity = 0,
                    color = {255, 255, 255, 255}
                })
            else
                table.insert(segments, {
                    text = optionText,
                    isWave = false,
                    waveIntensity = 0,
                    shakeIntensity = 0,
                    color = currentColor
                })
            end
        elseif part:match("^SHAKE%s%d+$") then
            if currentSegment.text ~= "" then
                table.insert(segments, currentSegment)
                currentSegment = { text = "", isWave = false, waveIntensity = 0, shakeIntensity = 0, color = currentColor }
            end
            currentSegment.shakeIntensity = tonumber(part:match("%d+"))
        elseif part:match("^WAVE%s%d+$") then
            if currentSegment.text ~= "" then
                table.insert(segments, currentSegment)
                currentSegment = { text = "", isWave = false, waveIntensity = 0, shakeIntensity = 0, color = currentColor }
            end
            local intensity = tonumber(part:match("%d+"))
            currentSegment.isWave = intensity > 0
            currentSegment.waveIntensity = intensity
        elseif part:match("^COLOR%s#%x%x%x%x%x%x$") then
            if currentSegment.text ~= "" then
                table.insert(segments, currentSegment)
                currentSegment = { text = "", isWave = false, waveIntensity = 0, shakeIntensity = 0, color = currentColor }
            end
            local hexColor = part:match("#%x%x%x%x%x%x")
            currentSegment.color = { hex_to_rgb(hexColor) }
        else
            currentSegment.text = currentSegment.text .. part
        end
    end

    if currentSegment.text ~= "" then
        table.insert(segments, currentSegment)
    end

    local xOffset = 0
    for _, segment in ipairs(segments) do
        local textPart = segment.text
        local wave = segment.isWave
        local waveIntensity = segment.waveIntensity
        local shakeIntensity = segment.shakeIntensity
        local color = segment.color

        local len = #textPart
        for i = 1, len do
            local char = textPart:sub(i, i)
            local waveOffset = wave and (waveIntensity * math.sin((globalTimer * waveSpeed) + i * 0.25)) or 0
            local charX = x + xOffset
            local charY = y + waveOffset

            table.insert(waveText, { char = char, x = charX, y = charY, shake = shakeIntensity, color = color })

            xOffset = xOffset + djui_hud_measure_text(char) * scale
        end
    end

    return waveText
end

local function print_dialog_text_progressive(displayText, x, y, scale, scrollOffset)
    local prevScale = scale
    local waveSpeed = 0.2
    local maxLines = math.floor(dialogHeight / (scale * 0.25 + LINE_SPACING))

    local lines = {}
    for line in displayText:gmatch("[^\n]+") do
        table.insert(lines, line)
    end

    for i = 1, #lines do
        local lineY = y + (i - 1) * (scale * 0.25 + LINE_SPACING) - scrollOffset
        local lineX = x

        if lineY >= y and lineY <= y + dialogHeight then
            local line = lines[i]
            local waveText = handle_text_effect(line, lineX, lineY, scale, 0, waveSpeed)
            for _, charData in ipairs(waveText) do
                local shakeX = 0
                local shakeY = 0

                if get_global_timer() % 2 == 0 then
                    shakeX = math.random(-charData.shake, charData.shake)
                    shakeY = math.random(-charData.shake, charData.shake)
                end

                djui_hud_set_color(charData.color[1], charData.color[2], charData.color[3], charData.color[4])
                djui_hud_print_text_interpolated(charData.char, charData.x + shakeX, charData.y + shakeY, prevScale, charData.x + shakeX, charData.y + shakeY, scale)
            end
        end
    end
end

local function print_dialog_text(pages, currentPage, nextPage, x, y, scale, scrollOffset)
    local lines = pages[currentPage] or {}
    local nextLines = pages[nextPage] or {}

    local prevScale = scale
    local waveSpeed = 0.2

    for i, line in ipairs(lines) do
        local lineY = y + (i - 1) * (scale * 0.25 + LINE_SPACING) - scrollOffset
        local lineX = x
        if lineY >= y and lineY <= y + dialogHeight then
            local waveText = handle_text_effect(line, lineX, lineY, scale, 0, waveSpeed)
            for _, charData in ipairs(waveText) do

                local shakeX = 0
                local shakeY = 0

                if get_global_timer() % 2 == 0 then
                    shakeX = math.random(-charData.shake, charData.shake)
                    shakeY = math.random(-charData.shake, charData.shake)
                end

                djui_hud_set_color(charData.color[1], charData.color[2], charData.color[3], charData.color[4])

                djui_hud_print_text_interpolated(charData.char, charData.x + shakeX, charData.y + shakeY, prevScale, charData.x + shakeX, charData.y + shakeY, scale)
            end
        end
    end

    for i, line in ipairs(nextLines) do
        local lineY = y + (i - 1 + #lines) * (scale * 0.25 + LINE_SPACING) - scrollOffset
        local lineX = x
        if lineY >= y and lineY <= y + dialogHeight then
            local waveText = handle_text_effect(line, lineX, lineY, scale, 0, waveSpeed)
            for _, charData in ipairs(waveText) do

                local shakeX = math.random(-charData.shake, charData.shake)
                local shakeY = math.random(-charData.shake, charData.shake)

                djui_hud_set_color(charData.color[1], charData.color[2], charData.color[3], charData.color[4])

                djui_hud_print_text_interpolated(charData.char, charData.x + shakeX, charData.y + shakeY, prevScale, charData.x + shakeX, charData.y + shakeY, scale)
            end
        end
    end
end

local function close_dialog()
    if sDialogHandler[currDialog].closeFunc then
        sDialogHandler[currDialog].closeFunc()
    end
    ps[0].isReading = false
    currDialog = nil
    boxState = DIALOG_STATE_OPENING
    dialogTimer = 0
    currentPage = 1
    charIndex = 0
end

local function opening_state_vanilla()
    local scale = math.min(dialogTimer / DIALOG_DURATION, 1)

    local angle = dialogTimer * DIALOG_ROTATION_SPEED
    local scaledWidth = dialogWidth * scale
    local scaledHeight = (dialogHeight + LINE_SPACING * 1.5) * scale

    djui_hud_set_color(boxColor.r, boxColor.g, boxColor.b, boxColor.a)
    djui_hud_set_rotation(angle, 0, 0)
    djui_hud_render_rect(dialogPosX, dialogPosY, scaledWidth, scaledHeight)

    if dialogTimer >= DIALOG_DURATION then
        boxState = DIALOG_STATE_OPENED
        dialogTimer = 0
    end
end

local function scrolling_state_vanilla()
    scrollTimer = scrollTimer + 1
    scrollOffset = scrollTimer * SCROLL_STEP

    djui_hud_set_color(boxColor.r, boxColor.g, boxColor.b, boxColor.a)
    djui_hud_render_rect(dialogPosX, dialogPosY, dialogWidth, dialogHeight + LINE_SPACING * 1.5)

    djui_hud_set_font(FONT_NORMAL)
    djui_hud_set_color(255, 255, 255, 255)

    local pages = paginate_text(sDialogHandler[currDialog].text, linesPerPage)
    totalPages = #pages

    local nextPage = math.min(currentPage + 1, totalPages)
    print_dialog_text(pages, currentPage, nextPage, dialogPosX + (TEXT_SCALE * 0.25) + 5, dialogPosY + (TEXT_SCALE * 0.25) + 5, TEXT_SCALE * 0.25, scrollOffset)

    if scrollTimer >= scrollLength then
        boxState = DIALOG_STATE_OPENED
        scrollTimer = 0
        scrollOffset = 0
        currentPage = nextPage
        dialogTimer = 0
    end
end

local function parse_options(dialogText)
    local options = {}
    for option in dialogText:gmatch("__OPTION (%d+)__ ([^__]+)") do
        local id, text = option:match("(%d+)__ ([^__]+)")
        table.insert(options, {id = tonumber(id), text = text})
    end
    totalOptions = #options
    return options
end

local function opened_state_vanilla(m)
    djui_hud_set_color(boxColor.r, boxColor.g, boxColor.b, boxColor.a)
    djui_hud_render_rect(dialogPosX, dialogPosY, dialogWidth, dialogHeight + LINE_SPACING * 1.5)

    djui_hud_set_font(FONT_NORMAL)
    djui_hud_set_color(255, 255, 255, 255)

    local pages = paginate_text(sDialogHandler[currDialog].text, linesPerPage)
    totalPages = #pages

    local options = parse_options(sDialogHandler[currDialog].text)
    totalOptions = #options

    handle_menu_navigation()

    print_dialog_text(pages, currentPage, currentPage + 1, dialogPosX + (TEXT_SCALE * 0.25) + 5, dialogPosY + (TEXT_SCALE * 0.25) + 5, TEXT_SCALE * 0.25, 0)

    if currentPage < totalPages then
        if dialogTimer > 15 then
            dialogTimer = 0
            showArrow = not showArrow
        end
        
        if showArrow then
            djui_hud_set_color(boxColor.r, boxColor.g, boxColor.b, boxColor.a)
            local vX = dialogPosX + dialogWidth - 8
            local vY = dialogPosY + dialogHeight + (LINE_SPACING * 1.5) + 2
            djui_hud_set_font(FONT_TINY)
            djui_hud_render_rect(vX - 2, vY - 1, gTextures.arrow_down.width + 2, gTextures.arrow_down.height + 2)
            djui_hud_set_color(255, 255, 255, 255)
            djui_hud_render_texture(gTextures.arrow_down, vX - 1, vY, 1, 1)
            djui_hud_set_font(FONT_NORMAL)
        end
    end

    if m.controller.buttonPressed & A_BUTTON ~= 0 then
        if currentPage < totalPages then
            play_sound(SOUND_MENU_MESSAGE_NEXT_PAGE, gGlobalSoundSource)
            boxState = DIALOG_STATE_SCROLLING
            selectedOption = 1
            scrollTimer = 0
            dialogTimer = 0
        else
            play_sound(SOUND_MENU_MESSAGE_DISAPPEAR, gGlobalSoundSource)
            boxState = DIALOG_STATE_CLOSING
            dialogTimer = 0
        end
    end
end

local function closing_state_vanilla()
    local scale = math.max(1 - (dialogTimer / DIALOG_DURATION), 0)
    local angle = -dialogTimer * DIALOG_ROTATION_SPEED

    djui_hud_set_color(boxColor.r, boxColor.g, boxColor.b, boxColor.a)
    djui_hud_set_rotation(angle, 0, 0)
    djui_hud_render_rect(dialogPosX, dialogPosY, dialogWidth * scale, dialogHeight * scale)

    if dialogTimer >= DIALOG_DURATION then
        close_dialog()
    end
end

local charIndex = 0

local periodDelay = 10
local commaDelay = 5
local defaultDelay = 0

local currentPrintDelay = 0

local function opened_state_progressive(m)
    djui_hud_set_color(boxColor.r, boxColor.g, boxColor.b, boxColor.a)
    djui_hud_render_rect(dialogPosX, dialogPosY, dialogWidth, dialogHeight + LINE_SPACING * 1.5)

    djui_hud_set_font(FONT_NORMAL)
    djui_hud_set_color(255, 255, 255, 255)

    local pages = paginate_text(sDialogHandler[currDialog].text, linesPerPage)
    totalPages = #pages

    local options = parse_options(sDialogHandler[currDialog].text)
    totalOptions = #options

    local currentPageText = pages[currentPage]
    local displayText = ""

    local totalCharsOnPage = 0
    for _, line in ipairs(currentPageText) do
        totalCharsOnPage = totalCharsOnPage + #line + 1
    end

    if currentPrintDelay <= 0 then
        if charIndex < totalCharsOnPage then
            charIndex = charIndex + 1

            local revealedChars = 0
            for _, line in ipairs(currentPageText) do
                revealedChars = revealedChars + #line + 1
                if revealedChars >= charIndex then
                    local currentChar = string.sub(line, charIndex - (revealedChars - #line), charIndex - (revealedChars - #line))
                    
                    if currentChar == "." or currentChar == "?" or currentChar == "!" then
                        currentPrintDelay = periodDelay
                    elseif currentChar == "," then
                        currentPrintDelay = commaDelay
                    else
                        currentPrintDelay = defaultDelay
                    end

                    break
                end
            end

            play_sound(SOUND_OBJ_KOOPA_WALK, gGlobalSoundSource)
        end
    else
        currentPrintDelay = currentPrintDelay - 1
    end

    local revealedChars = 0
    for _, line in ipairs(currentPageText) do
        if revealedChars + #line + 1 <= charIndex then
            displayText = displayText .. line .. "\n"
            revealedChars = revealedChars + #line + 1
        else
            displayText = displayText .. line:sub(1, charIndex - revealedChars) .. "\n"
            break
        end
    end

    print_dialog_text_progressive(displayText, dialogPosX + 5, dialogPosY + 5, TEXT_SCALE * 0.25, scrollOffset)

    if currentPage < totalPages then
        if dialogTimer > 15 then
            dialogTimer = 0
            showArrow = not showArrow
        end
        
        if showArrow then
            djui_hud_set_color(255, 255, 255, 255)
            local vX = dialogPosX + dialogWidth - 15
            local vY = dialogPosY + dialogHeight + (LINE_SPACING * 1.5) - 15
            djui_hud_set_font(FONT_TINY)
            djui_hud_render_texture(gTextures.arrow_down, vX, vY, 1, 1)
            djui_hud_set_font(FONT_NORMAL)
        end
    end

    if charIndex >= totalCharsOnPage then
        handle_menu_navigation()
        if m.controller.buttonPressed & A_BUTTON ~= 0 then
            if currentPage < totalPages then
                play_sound(SOUND_MENU_MESSAGE_NEXT_PAGE, gGlobalSoundSource)
                boxState = DIALOG_STATE_SCROLLING
            else
                play_sound(SOUND_MENU_MESSAGE_DISAPPEAR, gGlobalSoundSource)
                boxState = DIALOG_STATE_CLOSING
            end
            scrollTimer = 0
            dialogTimer = 0
            charIndex = 0
        end
    else
        if m.controller.buttonPressed & A_BUTTON ~= 0 then
            charIndex = totalCharsOnPage
        end
    end
end


local function opening_state_progressive()
    local alpha = clamp(dialogTimer * 10, 0, boxColor.a)
    djui_hud_set_color(boxColor.r, boxColor.g, boxColor.b, alpha)
    djui_hud_render_rect(dialogPosX, dialogPosY, dialogWidth, dialogHeight + LINE_SPACING * 1.5)

    if alpha >= boxColor.a then
        boxState = DIALOG_STATE_OPENED
        dialogTimer = 0
    end
end

local function scrolling_state_progressive()
    djui_hud_set_color(boxColor.r, boxColor.g, boxColor.b, boxColor.a)
    djui_hud_render_rect(dialogPosX, dialogPosY, dialogWidth, dialogHeight + LINE_SPACING * 1.5)

    charIndex = 0
    local nextPage = math.min(currentPage + 1, totalPages)
    currentPage = nextPage

    boxState = DIALOG_STATE_OPENED
end

local function closing_state_progressive()
    local pages = paginate_text(sDialogHandler[currDialog].text, linesPerPage)
    totalPages = #pages

    local fadeOutSpeed = 5

    local boxAlpha = boxColor.a - (dialogTimer * fadeOutSpeed)

    boxAlpha = clamp(boxAlpha, 0, boxColor.a)

    djui_hud_set_color(boxColor.r, boxColor.g, boxColor.b, boxAlpha)
    djui_hud_render_rect(dialogPosX, dialogPosY, dialogWidth, dialogHeight + LINE_SPACING * 1.5)

    if boxAlpha <= 0 then
        close_dialog()
        dialogTimer = 0
    end
end

local sStyleToDialogState = {
    [DIALOG_STYLE_VANILLA] = {
        [DIALOG_STATE_OPENING] = opening_state_vanilla,
        [DIALOG_STATE_SCROLLING] = scrolling_state_vanilla,
        [DIALOG_STATE_OPENED] = opened_state_vanilla,
        [DIALOG_STATE_CLOSING] = closing_state_vanilla,
    },
    [DIALOG_STYLE_PROGRESSIVE] = {
        [DIALOG_STATE_OPENING] = opening_state_progressive,
        [DIALOG_STATE_SCROLLING] = scrolling_state_progressive,
        [DIALOG_STATE_OPENED] = opened_state_progressive,
        [DIALOG_STATE_CLOSING] = closing_state_progressive,
    }
}

local function on_hud_render()
    djui_hud_set_resolution(RESOLUTION_N64)
    djui_hud_set_font(FONT_NORMAL)
    local sWidth = djui_hud_get_screen_width()
    local sHeight = djui_hud_get_screen_height()

    if not ps[0].isReading or not currDialog then return end

    local m = gMarioStates[0]

    m.freeze = 1

    dialogWidth = sDialogHandler[currDialog].scale.width
    dialogHeight = sDialogHandler[currDialog].scale.height
    dialogPosX = sDialogHandler[currDialog].pos.x
    dialogPosY = sDialogHandler[currDialog].pos.y

    linesPerPage = math.floor(dialogHeight / LINE_SPACING)
    scrollLength = (linesPerPage * 2) * (5 / SCROLL_STEP)

    dialogTimer = dialogTimer + 1

    if sDialogHandler[currDialog].loopFunc and currDialog then
        sDialogHandler[currDialog].loopFunc(sWidth, sHeight)
    end

    local func = sStyleToDialogState[style][boxState]
    if func then
        func(m)
    end
end

function open_dialog(dialog)
    if ps[0].isReading then return false end
    play_sound(SOUND_MENU_MESSAGE_APPEAR, gGlobalSoundSource)
    ps[0].isReading = true
    currDialog = dialog
    dialogTimer = 0
    currentPage = 1
    scrollTimer = 0
    scrollOffset = 0
    style = sDialogHandler[dialog].style or DIALOG_STYLE_VANILLA
    boxColor = sDialogHandler[dialog].color or {r=0, g=0, b=0, a=150}

    if sDialogHandler[dialog].openFunc then
        sDialogHandler[dialog].openFunc()
    end
end

hook_event(HOOK_ON_HUD_RENDER, on_hud_render)

local ACT_MODDED_READING_SIGN = allocate_mario_action(0x108 | ACT_FLAG_STATIONARY | ACT_FLAG_INTANGIBLE)

local function act_modded_reading_sign(m)
    if not m then
        return true
    end

    if not gPlayerSyncTable[m.playerIndex].isReading then return set_mario_action(m, ACT_IDLE, 0) end

    local marioObj = m.marioObj

    if m.playerIndex ~= 0 then
        set_character_animation(m, CHAR_ANIM_FIRST_PERSON)
        return false
    end

    play_sound_if_no_flag(m, SOUND_ACTION_READ_SIGN, MARIO_ACTION_SOUND_PLAYED)

    if m.actionState == 0 then
        set_character_animation(m, CHAR_ANIM_FIRST_PERSON)
        m.actionState = 1

    elseif m.actionState == 1 then
        m.faceAngle.y = m.faceAngle.y + marioObj.oMarioPoleUnk108 / 11
        m.pos.x = m.pos.x + marioObj.oMarioReadingSignDPosX / 11.0
        m.pos.z = m.pos.z + marioObj.oMarioReadingSignDPosZ / 11.0

        m.actionTimer = m.actionTimer + 1
        if m.actionTimer == 10 then
            if m == gMarioStates[0] and m.usedObj then
                open_dialog(m.usedObj.oBehParams2ndByte)
            end
            m.actionState = 2
        end
    end

    vec3f_copy(marioObj.header.gfx.pos, m.pos)
    vec3s_set(marioObj.header.gfx.angle, 0, m.faceAngle.y, 0)

    return false
end

hook_mario_action(ACT_MODDED_READING_SIGN, act_modded_reading_sign)

local sCanReadActions = {
    [ACT_IDLE] = true,
    [ACT_JUMP] = true,
    [ACT_PUNCHING] = true,
    [ACT_MOVE_PUNCHING] = true,
    [ACT_WALKING] = true,
}

local function mario_can_talk(m)
    if not m then return false end

    return sCanReadActions[m.action] --and not gPlayerSyncTable[m.playerIndex].isReading
end

local function check_read_sign(m, o)
    if not m or not o then
        return false
    end

    if (m.input & (INPUT_B_PRESSED | INPUT_A_PRESSED)) ~= 0 and obj_check_hitbox_overlap(m.marioObj, o) then
        local facingDYaw = (o.oMoveAngleYaw + 0x8000 - m.faceAngle.y) % 0x10000
        if facingDYaw > 0x8000 then
            facingDYaw = facingDYaw - 0x10000
        end

        if facingDYaw >= -0x4000 and facingDYaw <= 0x4000 and mario_can_talk(gMarioStates[0]) then
            local angleInRadians = o.oMoveAngleYaw * (math.pi / 32768)

            local targetX = o.oPosX + 105.0 * math.sin(angleInRadians)
            local targetZ = o.oPosZ + 105.0 * math.cos(angleInRadians)

            m.marioObj.oMarioReadingSignDYaw = facingDYaw
            m.marioObj.oMarioReadingSignDPosX = targetX - m.pos.x
            m.marioObj.oMarioReadingSignDPosZ = targetZ - m.pos.z

            m.interactObj = o
            m.usedObj = o

            m.pos.y = o.oPosY

            return true
        end
    end

    return false
end


local function can_read_npc_check(m, o)

    if (not m or not o) then return false end
    if ((m.input & (INPUT_B_PRESSED | INPUT_A_PRESSED) ~= 0) and mario_can_talk(m)) then
        local facingDYaw = mario_obj_angle_to_object(m, o) - m.faceAngle.y
        if (facingDYaw >= -0x4000 and facingDYaw <= 0x4000) and not gPlayerSyncTable[m.playerIndex].isReading then

            return true
        end
    end
end

local function sign_init(o)
    o.oFlags = OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE | OBJ_FLAG_SET_FACE_ANGLE_TO_MOVE_ANGLE
    
    local hitbox = get_temp_object_hitbox()

    o.oAction = 0

    if o.oBehParams >> 24 >= 1 then
        o.oAnimations = gObjectAnimations.bobomb_seg8_anims_0802396C
        hitbox.interactType = INTERACT_WATER_RING
        hitbox.height = 60
        hitbox.radius = 100
        obj_set_hitbox(o, hitbox)
    else
        o.collisionData = gGlobalObjectCollisionData.wooden_signpost_seg3_collision_0302DD80
        hitbox.interactType = INTERACT_WATER_RING
        hitbox.height = 80
        hitbox.radius = 100
        obj_set_hitbox(o, hitbox)
    end
end

local function sign_loop(o)
    if o.oBehParams >> 24 >= 1 then
        if o.oAction == 0 then
            obj_init_animation(o, 0)
            cur_obj_push_mario_away_from_cylinder(100, 60)

            local animFrame = o.header.gfx.animInfo.animFrame
            if ((animFrame == 5) or (animFrame == 16)) then
                cur_obj_play_sound_2(SOUND_OBJ_BOBOMB_WALK)
            end

            local player = nearest_player_to_object(o)

            local m = nearest_mario_state_to_object(o)

            if (player and dist_between_objects(o, player) < 1000.0) then
                o.oMoveAngleYaw = approach_s16_symmetric(o.oMoveAngleYaw, obj_angle_to_object(o, player), 0x140)
            end

            if can_read_npc_check(m, o) and o.oInteractStatus == INT_STATUS_INTERACTED and obj_check_hitbox_overlap(m.marioObj, o) then
                o.oInteractStatus = INT_STATUS_INTERACTED
                m.interactObj = o
                m.usedObj = o
                o.oAction = 1
                set_mario_action(m, ACT_MODDED_READING_SIGN, 50)
            end

        elseif o.oAction >= 1 then
            local animFrame = o.header.gfx.animInfo.animFrame
            if ((animFrame == 5) or (animFrame == 16)) then
                cur_obj_play_sound_2(SOUND_OBJ_BOBOMB_WALK)
            end
        
            local player = nearest_interacting_player_to_object(o)
            local angleToPlayer = player and obj_angle_to_object(o, player) or 0
            o.oMoveAngleYaw = approach_s16_symmetric(o.oMoveAngleYaw, angleToPlayer, 0x1000)
            local m = nearest_mario_state_to_object(o)
            if (o.oMoveAngleYaw == angleToPlayer) then
                open_dialog(o.oBehParams2ndByte)
                o.oAction = 0
            end
        
            cur_obj_play_sound_2(SOUND_ACTION_READ_SIGN)
        end
    else
        load_object_collision_model()
        if check_read_sign(gMarioStates[0], o) then
            set_mario_action(gMarioStates[0], ACT_MODDED_READING_SIGN, 0)
            open_dialog(o.oBehParams2ndByte)
        end
    end
    o.oInteractStatus = 0
end

id_bhvCustomSign = hook_behavior(nil, OBJ_LIST_SURFACE, true, sign_init, sign_loop, "bhvCustomSign")

local current_dialog = DIALOG_ID_0

local function mario_update(m)
    if m.playerIndex ~= 0 or not debug then return end

    if m.controller.buttonPressed & X_BUTTON ~= 0 then
        open_dialog(current_dialog)
        djui_chat_message_create("reading dialog id "..current_dialog)
    elseif m.controller.buttonPressed & L_JPAD ~= 0 then
        current_dialog = current_dialog - 1
        djui_chat_message_create("dialog id "..current_dialog)
    elseif m.controller.buttonPressed & R_JPAD ~= 0 then
        current_dialog = current_dialog + 1
        djui_chat_message_create("dialog id "..current_dialog)
    end

    if m.controller.buttonPressed & Y_BUTTON ~= 0 then
        spawn_non_sync_object(id_bhvCustomSign, E_MODEL_WOODEN_SIGNPOST, m.pos.x, m.pos.y, m.pos.z, function (sign)
            sign.oBehParams2ndByte = current_dialog
            sign.oBehParams = 0 << 24
        end)
    end
end

--hook_event(HOOK_MARIO_UPDATE, mario_update)